#define GEIGER_PIN 3  // Pin connected to Geiger counter output

volatile unsigned long lastEventTime = 0;
volatile bool newEvent = false;

void ISR_countEvent() {
    lastEventTime = micros();
    newEvent = true;
}

void setup() {
    Serial.begin(115200);
    pinMode(GEIGER_PIN, INPUT_PULLUP);
    attachInterrupt(digitalPinToInterrupt(GEIGER_PIN), ISR_countEvent, RISING);
}

void loop() {
    if (newEvent) {
        noInterrupts();
        unsigned long timestamp = lastEventTime;
        newEvent = false;
        interrupts();

        Serial.println(timestamp);
    }
}



